#include <Ultrasonic_Sensor.h>                   //βιβλιοθήκη για τον αισθητήρα υπερήχων
#include <Liquid_Crystal.h>                      //βιβλιοθήκη για την οθόνη LCD

const int trigPin = 3;                           // Δήλωση 1ης θύρας αισθητήρα υπερήχων
const int echoPin = 4;                           // Δήλωση 2ης θύρας αισθητήρα υπερήχων

float t;                                         //Χρόνος σε s που απαιτείται για τη μετάδοση του υπέρηχου από τον αισθητήρα έως το εμπόδιο
float u = 346.9;                                 // Ταχύτητα ήχου u=331.3+0.6*T; (ταχύτητα σε συνάρτηση με τη θερμοκρασία T σε κελσίου)
float x;                                         //απόσταση εμποδίου

LiquidCrystal myLCD(0x27, 16, 2);                // Δήλωση της Διεύθυνσης της οθόνης LCD. Η Σύνδεση πρέπει να γίνει στη θύρα I2C του Arduino

Ultrasonic_Sensor ultrasonic(trigPin, echoPin); // Εκκίνηση αισθητήρα υπερήχων

void setup() 
{
  myLCD.begin();                                // Εκκίνηση της οθόνης LCD
}

void loop() 
{
  ultrasonic.sendTriggerPulse();               // Στέλνουμε παλμό υπέρηχου στο εμπόδιο
  
  long duration = ultrasonic.readEcho();       // Χρόνος σε μS από την αποστολή του υπέρηχου έως την επιστροφή του στον αισθητήρα
  t = 0.5 * (duration / 1000000.0);            // Χρόνος σε s για μετάδοση του υπέρηχου από τον αισθητήρα έως το εμπόδιο
  x = u * t;                                   // Υπολογισμός απόστασης εμποδίου

  myLCD.Text("x=", 0, 0);                      // Εμφάνιση του κειμένου "x=" στη στη στηλη 1 γραμμή 1
  myLCD.Text(String(x, 3).c_str(), 2, 0);      // Εμφάνιση της απόστασης x με 3 δεκαδικά στη στηλη 3 γραμμή 1
  myLCD.Text("m", 7, 0);                       // Εμφάνιση της μονάδας μέτρησης "m" στη  στηλη 8 γραμμή 1

  delay(1000);                                 //καθυστέρηση 1s για να διαβάσουμε την τιμή
}
